//+------------------------------------------------------------------+  
//|                                                       JNRTRX.mq4 |
//|                    http://www.gustis.narod.ru;     gsb51@mail.ru |
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2
//----  
#property indicator_color1 Lime 
#property indicator_color2 Red
//----    --------------------------------------------------------------------------------------------------+
extern int  Length = 12;   //     
extern int  Smoth_ATR=18;
extern int  Multipiller  = 10; // ; 
extern int  Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
extern bool Line_Style=false;
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double JNRTRX[];
double UpTrendBuffer[];
double DownTrendBuffer[];
//+------------------------------------------------------------------+  
//----+   JurXSeries
//----+   JurXSeriesResize
//----+   JurXSeriesAlert 
//----+   JurX_ErrDescr  
#include <JurXSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| NRTR indicator initialization function                           | 
//+------------------------------------------------------------------+  
int init() 
{  
//---- 3      
IndicatorBuffers(3);
SetIndexBuffer(0,UpTrendBuffer); 
SetIndexBuffer(1,DownTrendBuffer); 
SetIndexBuffer(2,JNRTRX);
if (Line_Style==true)
 {
  //----   
  SetIndexStyle(0,DRAW_LINE); 
  SetIndexStyle(1,DRAW_LINE); 
 }
else
 {
  SetIndexStyle(0,DRAW_ARROW); 
  SetIndexStyle(1,DRAW_ARROW); 
  SetIndexArrow(0,159); 
  SetIndexArrow(1,159); 
 }
//----   ,      
SetIndexEmptyValue(0,0.0);
SetIndexEmptyValue(1,0.0);
//----         
IndicatorShortName ("JNRTRX( Length="+Length+", Multipiller="+Multipiller+")"); 
SetIndexLabel (0, "Up_Trend");
SetIndexLabel (1, "Down_Trend"); 
//----+      JurXSeries, nJurXnumber=1(    JurXSeries)
if (JurXSeriesResize(1)!=1)return(-1);
//----         
JurXSeriesAlert(0,"Length",Length); 
PriceSeriesAlert(Input_Price_Customs);
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| NRTR iteration function                                         | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----       
double Price,JurX,ATR,Resalt;
//----+        
int reset,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1; int limit=MaxBar-counted_bars;
//----+     
for(int bar=limit;bar>=0;bar--)
  {
DownTrendBuffer[bar]=0;
UpTrendBuffer  [bar]=0;
//----+    PriceSeries     Series
Price=PriceSeries(Input_Price_Customs,bar);
//+----------------------------------------------------------------------------+ 
//----+     JJMASeries   0/  nJMA.Phase  nJMA.Length      (nJMA.din=0)
//+----------------------------------------------------------------------------+   
JurX=JurXSeries(0,0,MaxBar,limit,Length,Price,bar,reset);
//----+       
if(reset!=0)return(-1);
//+----------------------------------------------------------------------------+ 
ATR =iATR(NULL,0,Smoth_ATR,bar)*Multipiller/10;
//-------- -------------
//----+    PriceSeries     Series
Price=PriceSeries(Input_Price_Customs,bar+1);
if(Price>JNRTRX[bar+1]){Resalt= JurX-ATR; UpTrendBuffer[bar]=Resalt;}
else
if(Price<JNRTRX[bar+1]){Resalt= JurX+ATR; DownTrendBuffer[bar]=Resalt;}
else  Resalt= JurX;
JNRTRX[bar]=Resalt;
  }
//----    
return(0); 
} 

//+--------------------------------------------------------+


